//libraries
//  LCD is in sketch folder
//  SD/SPI should be included in Arduino IDE
//  RTC uses RTClib by Adafruit (search rtclib in Library Manager) https://github.com/adafruit/RTClib

#include "LCD.h"
#include "Arial_round_16x24.c"
#include <SPI.h>
#include <SD.h>
#include "RTClib.h"
#include "audio.h"
#include "sounds.c"

button red=  {  3,240, 90,35,"Red",0,1};//x,y,w,h,text,pressed,visible
button green={ 99,240, 90,35,"Green",0,1};//x,y,w,h,text,pressed,visible
button blue= {195,240, 90,35,"Blue",0,1};//x,y,w,h,text,pressed,visible
button erase={291,240, 90,35,"Erase",0,1};//x,y,w,h,text,pressed,visible
button files={387,240, 90,35,"Files",0,1};//x,y,w,h,text,pressed,visible
slider backl={140,280,200,35,200,0,1};//x,y,w,h,value,pressed,visible

unsigned long draw=WHITE;
char fn[50]="";
File root,entry;
int sdStatus=0;

RTC_DS3231 rtc;
int rtcStatus=0;

void setup() {
  int i;
  Serial.begin(115200);
  //while(!Serial && millis()<5000){}
  displaySetup(); //this inits LCD controller, touch and backlight PWM
  setBacklight(100);
  setrotation(1);
  clear(BLACK);
  showarray(168,10,"Draw Demo",Arial_round_16x24,YELLOW,BLACK);
  drawbutton(&red);
  drawbutton(&green);
  drawbutton(&blue);
  drawbutton(&erase);
  drawbutton(&files);
  drawslider(&backl);
  sdStatus=SD.begin(SDCS);
  if(sdStatus){
    root = SD.open("/");
    entry=root.openNextFile();
    updateName(&entry);
  }
  SPIforLCD();     //reload LCD SPI settings for use after SD access
  if(sdStatus){
    showarray(10,50,"Card OK",Arial_round_16x24,GREY,BLACK);
  }else{
    showarray(10,50,"No Card",Arial_round_16x24,GREY,BLACK);
  }
  showarray(0,80,fn,Arial_round_16x24,GREY,BLACK);  
  Wire1.setSDA(10);
  Wire1.setSCL(11);
  rtcStatus=rtc.begin(&Wire1);  //BackPack uses I2C1 on pins 10 and 11
  if(rtcStatus){
    showarray(10,110,"RTC OK",Arial_round_16x24,GREY,BLACK);
  }else{
    showarray(10,110,"No RTC",Arial_round_16x24,GREY,BLACK);
  }
  audioInit();
  audioSetRate(8000);
}

void loop() {
  static int lastx,lasty;
  int x,y,p;
  x=touchx();
  y=touchy();
  if((x>-1)&&(y>-1&&(lastx>-1)&&(lasty>-1))){
    line(lastx,lasty,x,y,draw);
  }
  lastx=x;
  lasty=y;
  slidercheckpress(&backl);
  if(backl.pressed){
    drawslider(&backl);
      setBacklight((backl.value)/3+20);      //save it being fully off
  }
  checkpress(&red);
  if(red.lastchange==BUTTON_DOWN){draw=RED;}  //set draw colour on button down
  if(red.lastchange){drawbutton(&red);}        //redraw on change
  checkpress(&green);
  if(green.lastchange==BUTTON_DOWN){draw=GREEN;}
  if(green.lastchange){drawbutton(&green);}
  checkpress(&blue);
  if(blue.lastchange==BUTTON_DOWN){draw=BLUE;}
  if(blue.lastchange){drawbutton(&blue);}
  checkpress(&files);
  if(files.lastchange==BUTTON_DOWN){
    if(sdStatus){
      entry=root.openNextFile();
      updateName(&entry);
      if(!entry){root.rewindDirectory();fn[0]=0;}
    }
    SPIforLCD();     //reload LCD SPI settings for use after SD access
    showarray( 0,80,"                              ",Arial_round_16x24,GREY,BLACK);  
    showarray( 0,80,fn,Arial_round_16x24,GREY,BLACK);  
  }
  if(files.lastchange){drawbutton(&files);}
  checkpress(&erase);
  if(erase.lastchange==BUTTON_UP){drawbutton(&erase);clear(BLACK);}
  if(erase.lastchange){     //redraw all on screen erase
    drawbutton(&red);
    drawbutton(&green);
    drawbutton(&blue);
    drawbutton(&erase);
    drawbutton(&files);
    drawslider(&backl);
  }
  DateTime t = rtc.now();
  showTime(t);
  if((erase.lastchange==BUTTON_DOWN)||(red.lastchange==BUTTON_DOWN)||(green.lastchange==BUTTON_DOWN)||(blue.lastchange==BUTTON_DOWN)||(files.lastchange==BUTTON_DOWN)){
    if(audioSpace()){
      audioQueue(boop,sizeof(boop));
      audioPlay(AUDIO_PLAY_MONO);
    }
  }
  if((erase.lastchange==BUTTON_UP)||(red.lastchange==BUTTON_UP)||(green.lastchange==BUTTON_UP)||(blue.lastchange==BUTTON_UP)||(files.lastchange==BUTTON_UP)){
    if(audioSpace()){
      audioQueue(beep,sizeof(beep));
      audioPlay(AUDIO_PLAY_MONO);
    }
  }
  int i;
  //monitor IR pin
  for(i=0;i<480;i++){
    if(digitalRead(22)){
      point(i,50,WHITE);
    }else{
      point(i,50,BLACK);      
    }
  }
}

void updateName(File* entry){
  int i;
  if(*entry){
    for(i=0;i<30;i++){
      fn[i]=entry->name()[i];
    }
    fn[29]=0;
  }
}

void showTime(DateTime t){
  char s[30]="";
  int n;
  n=t.day();
  s[0]=(n/10)%10+'0';
  s[1]=(n/1)%10+'0';
  s[2]='/';
  n=t.month();
  s[3]=(n/10)%10+'0';
  s[4]=(n/1)%10+'0';
  s[5]='/';
  n=t.year();
  s[6]=(n/1000)%10+'0';
  s[7]=(n/100)%10+'0';
  s[8]=(n/10)%10+'0';
  s[9]=(n/1)%10+'0';
  s[10]=' ';
  n=t.hour();
  s[11]=(n/10)%10+'0';
  s[12]=(n/1)%10+'0';
  s[13]=':';
  n=t.minute();
  s[14]=(n/10)%10+'0';
  s[15]=(n/1)%10+'0';
  s[16]=':';
  n=t.second();
  s[17]=(n/10)%10+'0';
  s[18]=(n/1)%10+'0';  
  s[19]=0;
  showarray(10,140,s,Arial_round_16x24,GREY,BLACK);  
}
